function [s, logt] = depolarise(tau, E)
clf
n = []; m =[];
ef = E(:);

E( all(~E,2), : ) = [];

for mF = -4:1:4
    % Generate Hamiltonian matrix
    P1 = mFmat(mF);
    maxP1 = max(P1);
    ct = maxP1(1);
    L = (-1 +sqrt(1+8*ct))/2;
    a = 1:L.^2;
    a = reshape(a,L,L);
    H = zeros (L);
    H(triu(a) ~= 0) = P1(:,2);
    Htemp = (H + transpose(H)) - (diag(diag(H)));
    if mF == -4
        H0 = Htemp;
    else
        L0 = length(H0);
        H0 = [H0 zeros(L0, L); zeros(L, L0) Htemp];
    end

   
P1 = mFed(mF);
maxP1 = max(P1);
ct = maxP1(1);
L = (-1 + sqrt(1+8*ct))/2;
a = 1:L*L;
a = reshape(a,L,L);
He = zeros(L);
He(triu(a) ~= 0) = P1(:,2);
Hed = He + He' -diag(diag(He));

Hstemp = Hed - Htemp;
if mF == -4
    Hs = Hstemp;
else
    L0 = length (Hs);
    Hs = [Hs zeros(L0, L); zeros(L, L0) Hstemp];
end


% Quantum number labelling
n1 = zeros(L);
n1(triu(a) ~= 0) = P1(:,4);
n2 = diag(n1)';
m1 = ones(1, length(n2)).*mF;
n = [n n2];
m = [m m1];
end

% Initial state

Hstark = H0 + Hs.*ef(1);
[wf, e] = eig(Hstark);
e = diag(e);
[foo, ii] = sort(e);
wf = wf(:,ii);
iw = 40; % Chosen energy level of ND3
c = wf(:,iw);

% Spatial wavefunctions
th = linspace(-pi/2,pi/2,1000);
cth = cos(th);
sth = sin(th);
P = [];

for ni = unique(n);
    pp = legendre(ni, cth, 'norm');
    mi = abs(m(ni == n));
    pp = pp(mi+1, :)';
    P = [P, pp];
end
% Make block diagonal in m
[m, ii] = sort(m);  % Tidy up matrix
n = n(ii);
P = P(:,ii);

% Evolution of rotational/hyperfine state
nt = 1000;
%nt = length(ef);
logt = linspace(-12, -7, nt);
t = exp(log(10)*logt);
[ef, beta] = getfield (t, E, tau);

% Plot output

s = zeros(nt, 1);
figure(3)
p1 = plot(logt, s, 'b-');
hold on;
p2 = plot(logt, beta(1:end)./max(beta(1:end)), 'r--')
xlabel ('log_{10} t');
ylabel ('Population')
hold off;
drawnow

figure(4)
plot(logt, 1-((beta(1:end))./max(beta(1:end))),'r--')
xlabel ('log_{10} t');
ylabel ('Population')

%set(gcf, 'color', 'white')

% Time stepping
Ny = angmom(n, m);
wfo = wf;
pp = zeros(length(nt), length(n));

for it = 1:nt-1
    b = beta(it+1);
    dt = t(it+1) - t(it);
    db = (b - beta(it))./dt;
    U = expm (-1i*dt*((H0 + ef(it).*Hs) + db*Ny));
    c = U*c;
    Pt  = transpose(wf)*c;
    Pt = conj(Pt).*Pt;
    pp(it, :) = Pt;
    s(it) = 0;
    for x = 1:48;
        s(it) = s(it) + Pt(x);
    end
    [wf, e] = eig(Hstark);
    e = diag(e);
    
    % Maximise overlap for eigenvalue following
    over =  abs(wfo'*wf);
    [foo, ii] =  max(over, [], 2);
    wf = wf(:,ii);
    e = e(ii);
    wfo = wf;
    plotwf(P, b, th, cth, sth, c);
    set(p1, 'Xdata', logt(1:it), 'Ydata', s(1:it));
end

plotwf(P, beta(end), th, cth, sth, c)      

end

%-------------------------------------------------------------------------

function Ny = angmom (n,m)

% Matrix formulation of the J_y angular momentum operator

n = repmat (n, length(n), 1);
m = repmat (m, length(m), 1);

Ny = zeros (length(n),length(n));
ii = m'-1 == m;
n' == n;
Ny(ii) = -0.5*1i*sqrt((n(ii)-m(ii)).*(n(ii)+m(ii)+1));
ii = m'+1 == m;
n' == n;
Ny(ii) = 0.5*1i*sqrt((n(ii)+m(ii)).*(n(ii)-m(ii)+1));

end

%-------------------------------------------------------------------------

function [ef, beta] = getfield (t, E, tau)
        
% Calculate electric field magnitude and angle from the lab frame z-axis

for i = 1:length(t)
    Ez(i) = E(i)*exp(-t(i)/tau(1));  % Changed E(1) and E(2) to E(i) and E(i+1) 
    Ex(i) = E(i+1)*(1-exp(-t(i)/tau(2)));
    ef(i) = norm([Ex(i) Ez(i)]);
    beta(i) = atan(Ex(i)/Ez(i));
end

end

%-------------------------------------------------------------------------

function plotwf (P, beta, th, cth, sth, c)
% Plots wavefunction in the xz plane

a = P*c;
a = abs(a).^2;
z = a.*cth';
x = a.*sth';
area = polyarea(z, x);
a = 0.5*a./sqrt(area);
R = [cos(beta) -sin(beta); sin(beta) cos(beta)];
r = R*[z'; x'];
z = r(1,:)';
x = r(2,:)';
%figure(6)
%plot(x,z)

end




    

        
            
        
    